
## 一、FFmpeg 编解码流程

FFmpeg编解码流程图如下，此图包含了整体的解封装、编解码的基本流程。

![img](https://img2020.cnblogs.com/blog/682616/202104/682616-20210402124122366-1492811886.png)

下面我们要介绍的术语及相关API都是围绕这个流程图展开的。



## 二、FFmpeg 相关术语

**1. 容器/文件（Container/File）**：即特定格式的多媒体文件，比如MP4，flv，mov等。

**2. 媒体流（Stream）**：表示在时间轴上的一段连续的数据，比如一段声音数据、一段视频数据或者一段字母数据，可以是压缩的，也可以是非压缩的，压缩的数据需要关联特定的编解码器。

**3. 数据帧/数据包（Frame/Packet）**：通常一个媒体流是由大量的数据帧组成的，对于压缩数据，帧对应着编解码器的最小处理单元，分属于不同媒体流的数据帧交错存储与容器之中。

**4. 编解码器**：编解码器是以帧为单位实现压缩数据和原始数据之间的相互转换的。

前面介绍的术语，就是FFmpeg中抽象出来的概念。其中：

**1. AVFormatContext**：就是对容器或者媒体文件层次的抽象。

**2. AVStream**：在文件中（容器里面）包含了多路流（音频流、视频流、字幕流），AVStream 就是对流的抽象。

**3. AVCodecContext 与 AVCodec**：在每一路流中都会描述这路流的编码格式，对编解码器格式以及编解码器的抽象就是AVCodecContext 与 AVCodec。

**4. AVPacket 与 AVFrame**：对于编码器或者解码器的输入输出部分，也就是压缩数据以及原始数据的抽象就是AVPacket与AVFrame。

**5. AVFilte**r：除了编解码之外，对音视频的处理肯定是针对于原始数据的处理，也就是针对AVFrame的处理，使用的就是AVFilter。



## 三、FFmpeg 通用 API 分析



### 1. av_register_all 分析 

在最开始编译FFmpeg的时候，我们做了一个configure的配置，其中开启或者关闭了很多选项。configure的配置会生成两个文件：config.mk和config.h。

> config.mk：就是makefile文件需要包含进去的子模块，会作用在编译阶段，帮助开发者编译出正确的库。
>
> config.h：作用在运行阶段，主要是确定需要注册那些容器及编解码格式到FFmpeg框架中。

调用 av_register_all 就可以注册config.h里面开发的编解码器，然后会注册所有的Muxer和Demuxer（封装格式），最后注册所有的Protocol（协议）。

这样在configure时开启或者关闭的选项就作用到了运行时，该函数的源码分析设计的源码文件包括：url.c、allformats.c、mux.c、format.c 等文件。已经将这几个源码文件单独提出来了，并放在百度网盘上了，地址：https://pan.baidu.com/s/1p8-ish6oeRTaUs84juQtHg。



### 2. av_find_codec 分析

这个方法包含了两部分的内容：一部分是寻找解码器，一部分是寻找编码器。其实在av_register_all的函数执行时，就已经把编码器和解码器都存放到一个链表中了。这里寻找编解码器就是从上一步构造的链表中遍历，通过Codec的ID或者name进行条件匹配，最终返回对于的Codec。



### 3. avcodec_open2 分析

该函数是打开编解码器（Codec）的函数，无论是编码过程还是解码过程，都会用到这个函数。该函数的输入参数有三个：第一个是AVCodecContext，解码过程由FFmpeg引擎填充，编码过程由开发者自己构造，如果想传入私有参数，则为它的priv_data设置参数；第二个参数是上一步通过av_find_codec寻找出来的编解码器（Codec）；第三个参数一般传NULL。



### 4. avcodec_close 分析

如果理解了avcodec_open，那么对应的close就是一个逆过程，找到对应的实现文件中的close函数指针所只指向的函数，然后该函数会调用对应第三方库的API来关闭掉对应的编码库。



## 四、总结

本文主要是讲述了FFmpeg的相关术语，并讲解了一下通用的API的分析，不难看出其实FFmpeg所做的事情就是透明化所有的编解码库，用自己的封装来为开发者提供统一的接口。开发者使用不同的编码库时，只需要指明要用哪一个即可，这也充分体现了面向对象编程中的封装特性。
